<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Model_PurchaseLog extends XenCentral_AdServer_Model_Abstract
{
    public function logPayment($content_type, $content_id, $user_id, $dateline, $payment_info_id, $transaction_id)
    {
        $this->_getDb()->insert('xcas_transaction_log', array(
            'content_type' => $content_type,
            'content_id' => $content_id,
            'user_id' => $user_id,
            'dateline' => $dateline,
            'payment_info_id' => $payment_info_id,
            'transaction_id' => $transaction_id
        ));
    }

    public function getUserTransactions($user_id)
    {
        $transactions = $this->_getDb()->fetchAll("
            SELECT log.*, info.method, info.initinfo, transaction_log.status
            FROM xcas_transaction_log AS log
            LEFT JOIN xcfw_paymentapi_transaction AS info ON info.id=log.payment_info_id
            LEFT JOIN xcfw_paymentapi_transactionlog AS transaction_log ON transaction_log.infoid=log.payment_info_id AND transaction_log.transactionid=log.transaction_id
            WHERE log.user_id=?
            ORDER BY log.dateline DESC
        ", array($user_id));

        foreach ($transactions AS &$transaction) {
            if ($transaction['initinfo']) {
                $transaction['initinfo'] = unserialize($transaction['initinfo']);
                $transactionInfo = $transaction['initinfo']['info'];
            } else {
                $transactionInfo = array();
            }
            $item = new XenForo_Phrase('n_a');
            switch ($transaction['content_type']) {
                case 'banner':
                    if (!empty($transactionInfo['item_name'])) {
                        $item = $transactionInfo['item_name'];
                    } else {
                        $item = new XenForo_Phrase('xcas_user_banner_id_x', array('x' => $item['content_id']));
                    }
                    break;
            }
            if ($transaction['status'] == 'payment') {
                $action = new XenForo_Phrase('xcas_activated');
            } else if ($transaction['status'] == 'refund') {
                $action = new XenForo_Phrase('xcas_refunded');
            } else {
                $action = $transaction['status'];
            }
            $transaction['title'] = $item;
            $transaction['action'] = $action;
            $transaction['date'] = XenForo_Locale::dateTime($transaction['dateline']);
            if (!empty($transaction['initinfo']['additionalInfo']['package'])) {
                $transaction['package'] = $transaction['initinfo']['additionalInfo']['package']['fullName'];
            } else if (!empty($transactionInfo['amount'])) {
                $transaction['package'] = $transactionInfo['amount'] . ' ' . $transactionInfo['currency_code'];
            } else {
                $transaction['package'] = new XenForo_Phrase('n_a');
            }
            $method = explode('_', $transaction['method']);
            $method = end($method);
            try {
                $methodObject = XenCentral_PaymentApi_Module::getInstance()->getMethod($method);
                $method = $methodObject->getMethodIdentifier(true);
            } catch (Exception $ex) {
                // do nothing
            }
            $transaction['method'] = $method;
        }


        $this->_loadPhrases($transactions);

        return $transactions;
    }

    public function getTotalPaidCredit($bannerId)
    {
        $total = $this->_getDb()->fetchOne("
            SELECT SUM(price) AS total
            FROM xcas_click_credit_log
            WHERE bannerId=?
        ", array($bannerId));

        return array(
            XenForo_Application::getOptions()->get('xcas_transaction_currency')=> $total
        );
    }

    public function getTotalPaid($content_id, $content_type)
    {
        $total = array();

        $transactions = $this->_getDb()->fetchAll("
            SELECT log.*, info.method, info.initinfo, transaction_log.status
            FROM xcas_transaction_log AS log
            LEFT JOIN xcfw_paymentapi_transaction AS info ON info.id=log.payment_info_id
            LEFT JOIN xcfw_paymentapi_transactionlog AS transaction_log ON transaction_log.infoid=log.payment_info_id AND transaction_log.transactionid=log.transaction_id
            WHERE log.content_id=?
            AND log.content_type=?
        ", array($content_id, $content_type));

        foreach ($transactions AS $transaction) {
            if ($transaction['initinfo']) {
                $transaction['initinfo'] = unserialize($transaction['initinfo']);
                $transactionInfo = $transaction['initinfo']['info'];
            } else {
                // we do not have payment inforation, just skip this
                continue;
            }
            $currency=$transaction['initinfo']['additionalInfo']['package']['currency'];
            $amount=$transaction['initinfo']['additionalInfo']['package']['price'];
            if (isset($total[$currency])) {
                $total[$currency] += $amount;
            } else {
                $total[$currency] = $amount;
            }
        }

        return $total;
    }

    protected function _loadPhrases($array)
    {
        foreach ($array AS $index => $value) {
            if (is_array($value)) {
                $this->_loadPhrases($value);
                continue;
            }
            if (is_object($value) && $value instanceof XenForo_Phrase) {
                XenForo_Phrase::preloadPhrase($value->getPhraseName());
            }
        }
    }
}